# ISO 13485:2016 Mandatory Documents and Records

This document provides a complete list of all mandatory documents and records required by ISO 13485:2016 for medical device Quality Management Systems.

## Overview

ISO 13485:2016 requires organizations to establish and maintain **31 documented procedures** along with a **Quality Manual** and **Medical Device Files**. Additionally, numerous **records** must be maintained to provide evidence of conformity.

**Important Notes:**
- The 31 documented procedures do not need to be 31 separate documents
- Multiple procedures can be combined into one document
- One procedure can be split across multiple documents
- Not all procedures may be applicable to every organization (exclusions must be justified)
- Additional documentation may be required by applicable regulatory requirements

## 1. Quality Manual (Required by 4.2.2)

**Description:** Foundational QMS document

**Must Include:**
- Scope of QMS with justified exclusions
- Documented procedures or references to them
- Description of interaction between QMS processes
- Structure of documentation used in QMS

**Applicable To:** All organizations

---

## 2. Medical Device File (Required by 4.2.3)

**Description:** File for each medical device type or family

**Must Include:**
- General description and intended use
- Label and instructions for use specifications
- Product and/or manufacturing specifications
- Procedures for purchasing, manufacturing, servicing
- Measuring and monitoring procedures
- Installation requirements (if applicable)
- Risk management file(s)
- Verification and validation information
- Design and development file(s) when applicable

**Applicable To:** All organizations for each device type/family

---

## 3. The 31 Documented Procedures

### Clause 4: Quality Management System

#### 1. Risk Management Procedures (4.1.5)
**Description:** Requirements for risk management throughout product realization
**Must Address:**
- Risk management methodology
- Risk analysis and evaluation
- Risk control measures
- Risk acceptability criteria
- Risk management review
**Referenced Standard:** ISO 14971

#### 2. Software Validation Procedure (4.1.6)
**Description:** Validation of computer software applications used in QMS
**Must Address:**
- Risk assessment of software
- Validation approach and activities
- Acceptance criteria
- User responsibilities
- Validation before initial use and after changes
- Revalidation criteria

#### 3. Control of Documents Procedure (4.2.4)
**Description:** Control of all QMS documents
**Must Address:**
- Document approval before issue
- Document review and update
- Identification of changes and revision status
- Availability of relevant document versions
- Document legibility and identification
- Control of external documents
- Prevention of obsolete document use
- Identification of retained obsolete documents

#### 4. Control of Records Procedure (4.2.5)
**Description:** Control of all QMS records
**Must Address:**
- Record identification
- Storage and security
- Integrity protection
- Retrieval procedures
- Retention time determination
- Record disposition
- Legibility requirements
- Change identification

### Clause 5: Management Responsibility

#### 5. Management Review Procedure (5.6.1)
**Description:** Systematic review of QMS by top management
**Must Address:**
- Review frequency (at least annually)
- Review agenda and inputs
- Review outputs and actions
- Attendee requirements
- Record-keeping requirements

#### 6. Internal Communication Procedure (5.5.3)
**Description:** Communication regarding QMS effectiveness
**Must Address:**
- Communication channels
- Communication frequency
- Responsible parties
- Topics to be communicated
- Documentation of communications

### Clause 6: Resource Management

#### 7. Human Resources/Competence Procedure (6.2)
**Description:** Ensuring personnel competence
**Must Address:**
- Competence requirements determination
- Training needs identification
- Training provision and evaluation
- Education, training, skills, and experience requirements
- Competence records maintenance
- Awareness of personnel contributions

#### 8. Infrastructure Maintenance Procedure (6.3)
**Description:** Maintenance of facilities and equipment (when affecting quality)
**Must Address:**
- Maintenance activities definition
- Maintenance scheduling
- Maintenance records
- Impact on product quality
- Verification after maintenance

#### 9. Contamination Control Procedure (6.4.2)
**Description:** Control of contaminated or potentially contaminated product (when applicable)
**Must Address:**
- Contamination identification
- Contaminated product handling
- Segregation requirements
- Decontamination procedures
- Special arrangements for control

### Clause 7: Product Realization

#### 10. Customer Communication Procedure (7.2.3)
**Description:** Communication with customers
**Must Address:**
- Product information provision
- Inquiry, contract, order handling
- Customer feedback including complaints
- Advisory notices
- Communication channels and responsibilities

#### 11. Design and Development Procedures (7.3.1 - 7.3.10)
**Description:** Control of design and development process
**Must Address:**
- Design and development planning
- Input determination and review
- Output provision and approval
- Design reviews at suitable stages
- Verification against inputs
- Validation for intended use
- Transfer to manufacturing
- Change control
- Design file maintenance

#### 12. Purchasing Procedures (7.4.1)
**Description:** Control of purchasing process
**Must Address:**
- Supplier evaluation and selection criteria
- Supplier monitoring and re-evaluation
- Supplier performance tracking
- Purchasing controls
- Supplier notification of changes
- Communication to sub-tier suppliers

#### 13. Verification of Purchased Product Procedure (7.4.3)
**Description:** Verification that purchased product meets requirements
**Must Address:**
- Verification activities
- Extent of verification
- Method of product release
- Verification at supplier's premises (if applicable)
- Customer verification arrangements (if applicable)

#### 14. Production and Service Provision Control Procedures (7.5.1)
**Description:** Control of production and service activities
**Must Address:**
- Work instructions and documented procedures
- Use of suitable equipment
- Monitoring and measuring activities
- Release, delivery, and post-delivery activities
- Labelling and packaging operations
- Servicing procedures (if applicable)

#### 15. Product Cleanliness Procedures (7.5.2)
**Description:** Control of product cleanliness (when applicable)
**Must Address:**
- Cleaning requirements and specifications
- Cleaning before sterilization
- Uncleanable product handling
- Hygiene requirements in manufacturing
- Cleaning verification

#### 16. Installation and Verification Procedures (7.5.3)
**Description:** Installation activities (when applicable)
**Must Address:**
- Installation requirements
- Installation instructions
- Verification of installation
- Installation records
- Responsible parties

#### 17. Servicing Procedures (7.5.4)
**Description:** Servicing activities (when applicable)
**Must Address:**
- Servicing requirements
- Reference materials and measurements
- Feedback analysis from servicing
- Servicing records
- Servicing notification to regulatory authorities

#### 18. Process Validation Procedure (7.5.6)
**Description:** Validation of processes where output cannot be verified
**Must Address:**
- Process validation for manufacturing
- Computer software validation for production
- Sterilization process validation
- Aseptic processing validation
- Clean room validation (if applicable)
- Criteria for review and approval
- Equipment approval and personnel qualification
- Revalidation criteria and triggers

#### 19. Sterilization and Sterile Barrier System Validation (7.5.7)
**Description:** Validation of sterilization processes (when applicable)
**Must Address:**
- Sterilization method validation
- Sterile barrier system validation
- Process parameters for each batch
- Validation of changes to sterilization
- Maintenance of validation records

#### 20. Product Identification and Traceability Procedures (7.5.8, 7.5.9)
**Description:** Identification and traceability throughout realization
**Must Address:**
- Identification methods throughout realization
- Traceability extent definition
- Distribution and location tracking
- Consignee identification
- Quantity shipped identification
- Retention period requirements
- Applicable regulatory traceability requirements

#### 21. Customer Property Procedure (7.5.10)
**Description:** Control of customer-provided property
**Must Address:**
- Customer property identification
- Verification of customer property
- Protection and safeguarding
- Loss, damage, or unsuitability reporting
- Records of customer property

#### 22. Preservation of Product Procedure (7.5.11)
**Description:** Product preservation during processing and delivery
**Must Address:**
- Identification requirements
- Handling requirements
- Packaging requirements
- Storage requirements
- Protection requirements
- Special handling (if applicable)
- Application to constituent parts

#### 23. Control of Monitoring and Measuring Equipment Procedure (7.6)
**Description:** Calibration and control of measuring equipment
**Must Address:**
- Equipment identification
- Calibration or verification intervals
- Calibration methods and standards
- Adjustment procedures
- Identification of calibration status
- Protection from invalid adjustments
- Protection from damage
- Assessment when found non-conforming
- Computer software confirmation

### Clause 8: Measurement, Analysis and Improvement

#### 24. Feedback Procedure (8.2.1)
**Description:** Post-production information system
**Must Address:**
- Early warning system for quality issues
- Post-production information collection
- Complaint handling linkage
- Reporting to regulatory authorities
- Input to risk management
- Input to corrective and preventive action
- Feedback sources and channels

#### 25. Complaint Handling Procedure (8.2.2)
**Description:** Timely handling of complaints
**Must Address:**
- Complaint receipt and recording
- Complaint evaluation and investigation
- Determination of need for reporting to authorities
- Determination of need for advisory notices
- Information to customer about actions taken
- Transfer of complaint information not directly handled
- Complaint trending and analysis

#### 26. Reporting to Regulatory Authorities Procedure (8.2.3)
**Description:** Notification to regulatory authorities
**Must Address:**
- Determination of reportable events
- Notification timeframes
- Notification content requirements
- Advisory notice requirements
- Applicable regulatory requirements by region
- Responsible parties for reporting

#### 27. Internal Audit Procedure (8.2.4)
**Description:** Conduct of internal audits
**Must Address:**
- Audit program planning
- Audit criteria, scope, frequency, methods
- Auditor selection and impartiality
- Audit responsibilities and requirements
- Audit reporting
- Records of audits
- Follow-up activities

#### 28. Process Monitoring and Measurement Procedures (8.2.5)
**Description:** Monitoring and measurement of QMS processes
**Must Address:**
- Process monitoring methods
- Process measurement methods
- Demonstration of achieving planned results
- Implementation of corrections when needed
- Corrective actions when processes fail

#### 29. Product Monitoring and Measurement Procedures (8.2.6)
**Description:** Monitoring and measurement of product
**Must Address:**
- Product acceptance criteria
- Measurement at appropriate stages
- Release authority identification
- Release procedures
- Records of conformity to criteria
- Traceability to measuring authority

#### 30. Control of Nonconforming Product Procedure (8.3)
**Description:** Identification and control of nonconforming product
**Must Address:**
- Identification of nonconformity
- Documentation requirements
- Evaluation of nonconformity
- Segregation of nonconforming product
- Disposition of nonconforming product
- Notification to external parties
- Concession process (if applicable)
- Rework procedures
- Actions for nonconformity detected before delivery
- Actions for nonconformity detected after delivery
- Reporting requirements

#### 31A. Corrective Action Procedure (8.5.2)
**Description:** Elimination of causes of nonconformities
**Must Address:**
- Review of nonconformities including complaints
- Cause determination methodology
- Evaluation of need for action
- Planning and documentation of actions
- Implementation of actions
- Effectiveness review of actions
- Records of investigation and follow-up

#### 31B. Preventive Action Procedure (8.5.3)
**Description:** Elimination of causes of potential nonconformities
**Must Address:**
- Determination of potential nonconformities
- Evaluation of need for action
- Planning and documentation of actions
- Implementation of actions
- Effectiveness review of actions
- Sources of information for preventive action
- Records of investigation and follow-up

---

## Additional Required Documentation

### Analysis of Data Procedure (8.4)
While not explicitly called out as requiring a "documented procedure," organizations must establish processes for:
- Data determination, collection, and analysis
- Evaluation of continual improvement opportunities
- Statistical techniques (if applicable)
- Analysis of:
  - Customer satisfaction
  - Conformity to product requirements
  - Process and product characteristics and trends
  - Suppliers
  - Other relevant data including feedback and risk management outputs

---

## Required Records by Clause

### Clause 4 Records
- Software validation records (4.1.6)
- Risk management records (4.1.5)
- All records specified in documented procedures and work instructions
- All records required by applicable regulatory requirements

### Clause 5 Records
- Management review records (5.6.1)
- Evidence of personnel competence (6.2)

### Clause 6 Records
- Infrastructure maintenance records (6.3)
- Personnel training and competence records (6.2)

### Clause 7 Records
- Product requirements review and follow-up actions (7.2.2)
- Design and development files (7.3.10) including:
  - Design and development plans
  - Design inputs
  - Design outputs
  - Design review records
  - Design verification records
  - Design validation records
  - Design change records
  - Risk management file
- Design and development transfer records (7.3.8)
- Supplier evaluation, selection, and monitoring (7.4.1)
- Verification of purchased product (7.4.3)
- Cleanliness of product records (7.5.2)
- Installation and verification records (7.5.3)
- Servicing activity records (7.5.4)
- Sterilization process parameter records for each batch (7.5.5, 7.5.7)
- Process validation records (7.5.6)
- Product identification and traceability records (7.5.8, 7.5.9)
  - Including distribution records with consignee name/address and quantity (7.5.9.2)
- Customer property records (7.5.10)
- Calibration and verification records (7.6)

### Clause 8 Records
- Post-production feedback and complaints (8.2.1, 8.2.2)
- Complaint investigations (8.2.2)
- Regulatory authority reporting (8.2.3)
- Internal audit records (8.2.4)
- Process monitoring and measurement results (8.2.5)
- Product monitoring and measurement records (8.2.6)
- Product release authority (8.2.6)
- Nonconforming product records (8.3.1)
- Concession records and authority (8.3.2)
- Nonconforming product actions after delivery (8.3.3)
- Rework procedures and results (8.3.4)
- Data analysis results (8.4)
- Corrective action records including investigation and follow-up (8.5.2)
- Preventive action records including investigation and follow-up (8.5.3)

---

## Documentation Matrix

| Clause | Document Type | Document Name | Mandatory? | Records Required? |
|--------|--------------|---------------|------------|-------------------|
| 4.2.2 | Manual | Quality Manual | Yes | No |
| 4.2.3 | File | Medical Device File | Yes (per device) | Yes |
| 4.1.5 | Procedure | Risk Management | Yes | Yes |
| 4.1.6 | Procedure | Software Validation | Yes | Yes |
| 4.2.4 | Procedure | Control of Documents | Yes | No |
| 4.2.5 | Procedure | Control of Records | Yes | No |
| 5.5.3 | Procedure | Internal Communication | Yes | No |
| 5.6.1 | Procedure | Management Review | Yes | Yes |
| 6.2 | Procedure | Competence/Training | Yes | Yes |
| 6.3 | Procedure | Infrastructure Maintenance | When applicable | Yes |
| 6.4.2 | Procedure | Contamination Control | When applicable | Yes |
| 7.2.3 | Procedure | Customer Communication | Yes | Yes |
| 7.3.1-10 | Procedures | Design and Development | When applicable | Yes |
| 7.4.1 | Procedure | Purchasing | Yes | Yes |
| 7.4.3 | Procedure | Verification of Purchased Product | Yes | Yes |
| 7.5.1 | Procedures | Production Control | Yes | Yes |
| 7.5.2 | Procedure | Product Cleanliness | When applicable | Yes |
| 7.5.3 | Procedure | Installation | When applicable | Yes |
| 7.5.4 | Procedure | Servicing | When applicable | Yes |
| 7.5.6 | Procedure | Process Validation | When applicable | Yes |
| 7.5.7 | Procedure | Sterilization Validation | When applicable | Yes |
| 7.5.8 | Procedure | Product Identification | Yes | Yes |
| 7.5.9 | Procedure | Traceability | Yes | Yes |
| 7.5.10 | Procedure | Customer Property | When applicable | Yes |
| 7.5.11 | Procedure | Preservation of Product | Yes | Yes |
| 7.6 | Procedure | Control of M&M Equipment | Yes | Yes |
| 8.2.1 | Procedure | Feedback | Yes | Yes |
| 8.2.2 | Procedure | Complaint Handling | Yes | Yes |
| 8.2.3 | Procedure | Regulatory Reporting | Yes | Yes |
| 8.2.4 | Procedure | Internal Audit | Yes | Yes |
| 8.2.5 | Procedure | Process Monitoring | Yes | Yes |
| 8.2.6 | Procedure | Product Monitoring | Yes | Yes |
| 8.3 | Procedure | Control of Nonconforming Product | Yes | Yes |
| 8.4 | Process | Analysis of Data | Yes | Yes |
| 8.5.2 | Procedure | Corrective Action | Yes | Yes |
| 8.5.3 | Procedure | Preventive Action | Yes | Yes |

---

## Common Additional Documents (Not Required by ISO 13485 but Often Needed)

While not explicitly required by ISO 13485, the following documents are commonly needed for effective QMS operation and regulatory compliance:

### Work Instructions
- Manufacturing work instructions
- Testing work instructions
- Inspection work instructions
- Cleaning instructions
- Equipment operation instructions

### Forms and Templates
- Training records forms
- Calibration forms
- Audit checklists
- Complaint forms
- CAPA forms
- Change request forms
- Document review forms
- Supplier evaluation forms

### Additional Plans
- Quality plan
- Product realization plan
- Validation plans
- Clinical evaluation plans
- Post-market surveillance plans

### Technical Documentation
- Product specifications
- Material specifications
- Test methods and protocols
- Packaging specifications
- Labeling artwork
- Instructions for use

### Regulatory Documentation
- Technical files (EU MDR/IVDR)
- 510(k) submissions (FDA)
- Clinical evaluation reports
- Post-market surveillance reports
- Periodic safety update reports

---

## Tips for Document Management

### Combining Procedures
Multiple procedures can be combined into single documents, such as:
- "Corrective and Preventive Action (CAPA) Procedure" (combines 8.5.2 and 8.5.3)
- "Document and Record Control Procedure" (combines 4.2.4 and 4.2.5)
- "Monitoring and Measurement Procedure" (combines 8.2.5 and 8.2.6)
- "Product Identification and Traceability Procedure" (combines 7.5.8 and 7.5.9)

### Determining Applicability
Not all procedures apply to all organizations. Common exclusions include:
- Design and development (when only manufacturing per customer specifications)
- Installation (when product doesn't require installation)
- Servicing (when not offered)
- Sterilization (when product is non-sterile)
- Contamination control (when not applicable to product type)

All exclusions must be justified in the Quality Manual.

### Regulatory Requirements
Remember that applicable regulatory requirements may mandate additional documentation beyond ISO 13485, including:
- FDA regulations (21 CFR Part 820 / QMSR)
- EU MDR/IVDR requirements
- Health Canada requirements
- Other regional regulatory requirements

---

## Record Retention

Per ISO 13485:2016 (4.2.5), records must be retained for:
- **Minimum:** The lifetime of the medical device as defined by the organization
- **Additional:** Not less than the retention period of any resulting record
- **Regulatory:** As specified by applicable regulatory requirements

Organizations must define the "lifetime" of their medical devices and establish retention times that meet or exceed:
- ISO 13485 minimum requirements
- Applicable regulatory requirements (often 5-10 years minimum)
- Any customer contractual requirements

---

## Transition to Medical Device File (MDF)

With FDA QMSR harmonization (effective February 2, 2026), organizations should prepare for transitioning from separate files to a unified Medical Device File (MDF) that replaces:
- **DHF** (Design History File)
- **DMR** (Device Master Record)
- **DHR** (Device History Record)

The MDF approach aligns with ISO 13485:2016 requirements and provides a more unified documentation structure.
