# Surgical Pathology Report Template

## Patient and Specimen Information

**Patient Name:** [Last, First]  
**Medical Record Number:** [MRN]  
**Date of Birth:** [MM/DD/YYYY]  
**Age:** [years]  
**Sex:** [M/F]

**Accession Number:** [PathologyAccessionNumber]  
**Specimen Received:** [Date and time]  
**Report Date:** [Date]

**Ordering Physician:** [Name]  
**Clinical Service:** [Department]

---

## Specimen(s) Submitted

**Specimen A:** [Description of specimen]  
Example: "Skin, left forearm, excisional biopsy"

**Specimen B:** [If multiple specimens]

---

## Clinical History / Indication

[Relevant clinical information provided by clinician]

Example: "72-year-old woman with enlarging pigmented lesion on left forearm. Clinical concern for melanoma. Previous biopsy showed atypical melanocytic proliferation."

---

## Gross Description

**Specimen A labeled "[Specimen label]":**

**Description:**
- Received [fresh/in formalin]
- Consists of [specimen type] measuring [dimensions in cm]
- [External surface description]
- [Cut surface/sectioning description]
- [Lesion description if applicable]
- [Orientation markers if present]
- [Inking for margins]

**Sampling:**
- [How specimen was sectioned]
- [Cassette labeling]
- [Percent of tissue submitted]

**Example:**
```
Specimen A labeled "Skin, left forearm, excisional biopsy":
Received fresh is an oriented ellipse of skin measuring 3.5 x 1.2 x 0.8 cm with a 
suture indicating superior. The epidermis contains a 1.1 cm diameter irregularly 
pigmented lesion located 1.5 cm from superior, 1.2 cm from inferior, 0.8 cm from  
medial, and 1.2 cm from lateral margins. Inking: superior blue, inferior black, 
medial green, lateral red, deep yellow. Serially sectioned perpendicular to long 
axis into 10 slices. Entirely submitted in cassettes A1-A4.
```

---

## Microscopic Description

[Detailed histological findings]

**Architecture:**
[Structural patterns observed]

**Cytology:**
[Cell type, nuclear features, cytoplasm, pleomorphism]

**Special Features:**
[Necrosis, mitoses, invasion, margins]

**Stains/Immunohistochemistry Results:**
[Results of special stains or immunostains]

**Example:**
```
Sections show skin with an asymmetric melanocytic proliferation composed of 
epithelioid and spindled melanocytes arranged in irregular nests at the 
dermoepidermal junction with extension into the papillary and reticular dermis.
Melanocytes show marked cytologic atypia with nuclear enlargement, hyperchromasia,
and prominent nucleoli. Mitotic activity is present with 4 mitoses per mm². 
No ulceration identified. The lesion extends to a Breslow depth of 1.8 mm 
(Clark level IV). Margins are free of tumor (closest margin: deep, 0.3 cm).
```

---

## Diagnosis

**Specimen A, Skin, left forearm, excisional biopsy:**

**[DIAGNOSIS IN CAPITAL LETTERS]**

**Example Format:**
```
MALIGNANT MELANOMA, SUPERFICIAL SPREADING TYPE

Pathologic features:
- Breslow thickness: 1.8 mm
- Clark level: IV
- Mitotic rate: 4/mm²
- Ulceration: Absent
- Margins: Negative for melanoma (closest margin deep, 0.3 cm)
- Lymphovascular invasion: Not identified
- Perineural invasion: Not identified
- Regression: Absent
- Tumor-infiltrating lymphocytes: Present, non-brisk
- Microsatellites: Absent
```

**For Cancer Specimens - Synoptic Format (CAP Protocol):**

```
SYNOPTIC REPORT FOR [CANCER TYPE]

Procedure: [Type of resection]
Tumor Site: [Specific location]
Tumor Size: [Greatest dimension in cm]
Histologic Type: [WHO classification]
Histologic Grade: [Grading system and result]
Depth of Invasion: [Measured in mm if applicable]
Lymphovascular Invasion: [Present / Not identified]
Perineural Invasion: [Present / Not identified]
Margins:
  - [Margin name]: [Negative/Positive, distance if negative]
  - [All margins listed]
Regional Lymph Nodes:
  - Number examined: [X]
  - Number with metastasis: [Y]
  - Extranodal extension: [Present/Absent]
Pathologic Stage (AJCC 8th edition): [pTNM]
Additional Findings: [Other relevant findings]
```

---

## Ancillary Studies

**Immunohistochemistry:**

| Antibody | Result | Interpretation |
|----------|--------|----------------|
| [Marker name] | [Positive/Negative, pattern] | [Clinical significance] |

**Example:**
| Antibody | Result | Interpretation |
|----------|--------|----------------|
| S100 | Positive, diffuse | Supports melanocytic lineage |
| Melan-A | Positive, diffuse | Supports melanocytic lineage |
| HMB-45 | Positive, patchy | Supports melanoma |
| Ki-67 | 30% | High proliferative index |

**Molecular/Genetic Testing:**
[Results of molecular tests if performed]
- BRAF mutation: [Detected/Not detected]
- [Other relevant tests]

---

## Comment

[Additional interpretive information, differential diagnosis, recommendations]

**Example:**
```
The morphologic and immunohistochemical findings are diagnostic of melanoma. The 
Breslow thickness of 1.8 mm places this tumor in the T2 category (AJCC 8th edition).
Sentinel lymph node biopsy is recommended for staging. BRAF mutation testing may be 
considered for treatment planning. Close clinical follow-up is recommended.
```

---

## Signature

**Pathologist:**  
[Name, MD]  
[Board Certification]  
[License number]

**Electronically signed:** [Date and time]

**Gross examination by:** [Name, credentials]  
**Microscopic examination by:** [Name, MD]

---

## Template Notes for Different Specimen Types

### Breast Biopsy

**Key Elements:**
- Histologic type (invasive ductal, lobular, etc.)
- Nottingham grade (tubule formation, nuclear grade, mitotic count)
- Size of invasive component
- DCIS if present (grade, extent)
- ER/PR/HER2 status
- Margins for all components
- Lymph nodes if present

### Colon Resection

**Key Elements:**
- Tumor site and size
- Histologic type and grade
- Depth of invasion (T stage)
- Lymph nodes (number positive/total examined)
- Margins (proximal, distal, radial/circumferential)
- Lymphovascular and perineural invasion
- Tumor deposits
- MSI/MMR status

### Prostate Biopsy/Resection

**Key Elements:**
- Gleason score (pattern 1 + pattern 2 = total)
- Grade group (1-5)
- Percent involvement per core/specimen
- Extraprostatic extension (if radical prostatectomy)
- Seminal vesicle invasion
- Margins
- Perineural invasion

---

## Frozen Section Report (if applicable)

**Frozen Section Diagnosis:**

**Specimen:** [Description]  
**Clinical Question:** [Reason for frozen]  
**Frozen Section Diagnosis:** [Diagnosis given intraoperatively]  
**Time:** [Time reported]  
**Pathologist:** [Name]

**Note:** Permanent sections to follow.

**Final Diagnosis:** [State if concordant or discordant with frozen]


